; SPECTRUM PSG PLAYER V 3.7 - WYZ 2007
;
; Original code by WYZ 2007
; Optimizations by Metalbrain 2008

; CARACTERISTICAS
; 5 OCTAVAS:            O[2-6]=60 NOTAS
; 4 LONGITUDES DE NOTA: L[0-3]+PUNTILLO
; PUNTILLO
; COMANDOS:     T:TEMPO
;               I:INSTRUMENTO
;               S:REPRODUCTOR DE EFECTOS CANAL C

; LOS DATOS QUE HAY QUE VARIAR :

; * N DE CANCION.
; * TABLA DE CANCIONES



; POR HACER
; - ELEGIR CANAL DE EFECTOS
		org	49152

deexo_addr	EQU 08359H

		INCLUDE "vortex.asm"
;PLAYER:         DI

; MUSICA DATOS INICIALES


SILENCIAPLAYER:
                LD HL,PSG_REG
                LD DE,PSG_REG+1
                LD BC,29
                LD [HL],0
                LDIR
                LD A,10111000b
                LD [PSG_REG+7],A
                LD [PSG_REG_SEC+7],A
                JP ROUT
                
;CARGA UNA CANCION
;IN:[A]=N DE CANCION

CARGA_CANCION: 	;LD      HL,INTERR       ;CARGA CANCION
                ;SET     1,[HL]          ;REPRODUCE CANCION
                LD      HL,SONG
                LD      [HL],A          ;N A
                XOR     A
                LD      [TTEMPO],A

;DECODIFICAR
;IN-> INTERR 0 ON
;     SONG

;CARGA CANCION SI/NO

DECODE_SONG:    LD      A,[SONG]

;LEE CABECERA DE LA CANCION
;BYTE 0=TEMPO
                LD      HL,TABLA_SONG
                CALL    EXT_WORD

		ld	de,38912
		call	deexo_addr
		ld	hl,38912
                LD      A,[HL]
                LD      [TEMPO],A

;N DE PAUTA DEL CANAL A,B,C

                LD      IX,PUNTERO_P_A
                CALL    SET_PAUTA
                LD      IX,PUNTERO_P_B
                CALL    SET_PAUTA
                LD      IX,PUNTERO_P_C
                CALL    SET_PAUTA


;LEE DATOS DE LAS NOTAS
;[|][|||||] LONGITUD\NOTA

                LD      DE,[CANAL_A]
                LD      [PUNTERO_A],DE
                CALL    DECODE_CANAL    ;CANAL A
                LD      [CANAL_B],DE
                LD      [PUNTERO_B],DE
                CALL    DECODE_CANAL    ;CANAL B
                LD      [CANAL_C],DE
                LD      [PUNTERO_C],DE
                CALL    DECODE_CANAL    ;CANAL C
                LD      [CANAL_P],DE
                LD      [PUNTERO_P],DE
	    				;CANAL P
                
;DECODIFICA NOTAS DE UN CANAL
;IN [DE]=DIRECCION DESTINO
;NOTA=0 FIN CANAL
;NOTA=1 SILENCIO
;NOTA=2 PUNTILLO
;NOTA=3 COMANDO I

DECODE_CANAL:   INC     HL
                LD      A,[HL]
                AND     A               ;FIN DEL CANAL?
                JR      Z,FIN_DEC_CANAL
                CALL    GETLEN

                CP      00000001B       ;ES SILENCIO?
                JR      NZ,NO_SILENCIO
                SET     6,A
                JR      NO_MODIFICA

NO_SILENCIO:    CP      00111110B       ;ES PUNTILLO?
                JR      NZ,NO_PUNTILLO
                OR      A
                RRC     B
                XOR     A
                JR      NO_MODIFICA

NO_PUNTILLO:    CP      00111111B       ;ES COMANDO?
                JR      NZ,NO_MODIFICA
                BIT     0,B             ;COMADO=INSTRUMENTO?
                JR      Z,NO_INSTRUMENTO
                LD      A,11000001B     ;CODIGO DE INSTRUMENTO
                LD      [DE],A
                INC     HL
                INC     DE
                LD      A,[HL]          ;N DE INSTRUMENTO
                LD      [DE],A
                INC     DE
                JR      DECODE_CANAL

NO_INSTRUMENTO: BIT     2,B
                JR      Z,NO_ENVOLVENTE
                LD      A,11000100B     ;CODIGO ENVOLVENTE
                LD      [DE],A
                INC     DE
                JR      DECODE_CANAL

NO_ENVOLVENTE:  BIT     1,B
                JR      Z,NO_MODIFICA
                LD      A,11000010B     ;CODIGO EFECTO
                LD      [DE],A
                INC     HL
                INC     DE
                LD      A,[HL]
                CALL    GETLEN

NO_MODIFICA:    LD      [DE],A
                INC     DE
                XOR     A
                DJNZ    NO_MODIFICA
                JR      DECODE_CANAL

FIN_DEC_CANAL:  SET     7,A
                LD      [DE],A
                INC     DE
                RET

               
;INICIA PAUTA PARA UN CANAL
;IN [A]:  N DE PAUTA
;   [IX]: PUNTERO PAUTA

SET_PAUTA:      INC     HL
                LD      A,[HL]
                PUSH    HL
                LD      HL,TABLA_PAUTAS
                CALL    EXT_WORD
                LD      [IX+0],L
                LD      [IX+1],H
                LD      [IX+6],L
                LD      [IX+7],H
                POP     HL
                RET

GETLEN:         LD      B,A
                AND     00111111B
                PUSH    AF
                LD      A,B
                AND     11000000B
                RLCA
                RLCA
                INC     A
                LD      B,A
                LD      A,10000000B
DCBC0:          RLCA
                DJNZ    DCBC0
                LD      B,A
                POP     AF
                RET




;PLAY __________________________________________________


PLAY:           ;LD      HL,INTERR       ;PLAY BIT 1 ON?
                ;BIT     1,[HL]
                ;RET     Z
;TEMPO
                LD      HL,TTEMPO       ;CONTADOR TEMPO
                INC     [HL]
                LD      A,[TEMPO]
                CP      [HL]
                JR      NZ,PAUTAS
                LD      [HL],0

;INTERPRETA
                LD      IY,PSG_REG
                LD      IX,PUNTERO_A
                LD      BC,PSG_REG+8
                CALL    LOCALIZA_NOTA
                LD      IY,PSG_REG+2
                LD      IX,PUNTERO_B
                LD      BC,PSG_REG+9
                CALL    LOCALIZA_NOTA
                LD      IY,PSG_REG+4
                LD      IX,PUNTERO_C
                LD      BC,PSG_REG+10
                CALL    LOCALIZA_NOTA
                LD      IX,PUNTERO_P    ;EL CANAL DE EFECTOS ENMASCARA OTRO CANAL
                CALL    LOCALIZA_EFECTO

;PAUTAS

PAUTAS:         LD      IY,PSG_REG+0
                LD      IX,PUNTERO_P_A
                LD      HL,PSG_REG+8
                CALL    PAUTA           ;PAUTA CANAL A
                LD      IY,PSG_REG+2
                LD      IX,PUNTERO_P_B
                LD      HL,PSG_REG+9
                CALL    PAUTA           ;PAUTA CANAL B
                LD      IY,PSG_REG+4
                LD      IX,PUNTERO_P_C
                LD      HL,PSG_REG+10
                			;PAUTA CANAL C
; PAUTA DE LOS 3 CANALES
; IN:[IX]:PUNTERO DE LA PAUTA
;    [HL]:REGISTRO DE VOLUMEN
;    [IY]:REGISTROS DE FRECUENCIA

PAUTA:
                BIT     4,[HL]        ;SI LA ENVOLVENTE ESTA ACTIVADA NO ACTUA PAUTA
                RET     NZ
                PUSH	HL
                LD      L,[IX+0]
                LD      H,[IX+1]
                LD      A,[HL]

                BIT     7,A		;LOOP
                JR      Z,PCAJP0
                AND     00001111B       ;LOOP PAUTA [0,15]
                LD      D,0
                LD      E,A
                SBC     HL,DE
                LD      A,[HL]

PCAJP0:		BIT	6,A		;OCTAVA -1
		JR	Z,PCAJP1
		LD	E,[IY+0]
		LD	D,[IY+1]

		AND	A
		RRC	D
		RR	E
		LD	[IY+0],E
		LD	[IY+1],D
		JR	PCAJP2

PCAJP1:		BIT	5,A		;OCTAVA +1
		JR	Z,PCAJP2
		LD	E,[IY+0]
		LD	D,[IY+1]

		AND	A
		RLC	E
		RL	D
		LD	[IY+0],E
		LD	[IY+1],D


PCAJP2:		INC     HL
                LD      [IX+0],L
                LD      [IX+1],H
                POP	HL
                AND	00001111B
                LD      [HL],A
                RET

;REPRODUCE EFECTOS DE SONIDO

REPRODUCE_SONIDO:
                LD      HL,INTERR   
                BIT     2,[HL]          ;ESTA ACTIVADO EL EFECTO?
                RET     Z
                LD      HL,[PUNTERO_SONIDO]
                LD      A,[HL]
                CP      $FF
                JR      Z,FIN_SONIDO
                LD      [PSG_REG_SEC+0],A
                INC     HL
                LD      A,[HL]
                RRCA
                RRCA
                RRCA
                RRCA
                AND     00001111B
                LD      [PSG_REG_SEC+1],A
                LD      A,[HL]
                AND     00001111B
                LD      [PSG_REG_SEC+8],A
                INC     HL
                LD      A,[HL]
                AND     A
                JR      Z,NO_RUIDO
                LD      [PSG_REG_SEC+6],A
                LD      A,10110000B
                JR      SI_RUIDO
NO_RUIDO:       LD      A,10111000B
SI_RUIDO:       LD      [PSG_REG_SEC+7],A
       
                INC     HL
                LD      [PUNTERO_SONIDO],HL
                RET
FIN_SONIDO:     LD      HL,INTERR
                RES     2,[HL]

FIN_NOPLAYER:   ;XOR     A        
                ;LD      [PSG_REG+0],A
                ;LD      [PSG_REG+1],A
                ;LD      A,10111000B
                ;LD      [PSG_REG+7],A
                RET         

;VUELCA BUFFER DE SONIDO AL PSG

ROUT:          ; LD	A,[PSG_REG+0]
	       ; XOR	1
               ; LD	[PSG_REG+0],A

		XOR     A
ROUT_A0:        LD      DE,$FFBF
                LD      BC,$FFFD
                LD      HL,PSG_REG_SEC
LOUT:           OUT     [C],A
                LD      B,E
                OUTI
                LD      B,D
                INC     A
                CP      13
                JR      NZ,LOUT
                OUT     [C],A
                LD      A,[HL]
                AND     A
                RET     Z
                LD      B,E
                OUTI
                XOR     A
                LD      [PSG_REG_SEC+13],A
                LD      [PSG_REG+13],A
                RET


;LOCALIZA NOTA CANAL A
;IN [PUNTERO_A]

LOCALIZA_NOTA:  LD      L,[IX+0]       ;HL=[PUNTERO_A_C_B]
                LD      H,[IX+1]
                LD      A,[HL]
                AND     11000000B      ;COMANDO?
                CP      11000000B
                JR      NZ,LNJP0

;BIT[0]=INSTRUMENTO

COMANDOS:       LD      A,[HL]
                BIT     0,A             ;INSTRUMENTO
                JR      Z,COM_EFECTO

                INC     HL
                LD      A,[HL]          ;N DE PAUTA
                INC     HL
                LD      [IX+00],L
                LD      [IX+01],H
                LD      HL,TABLA_PAUTAS
                CALL    EXT_WORD
                LD      [IX+18],L
                LD      [IX+19],H
                LD      [IX+12],L
                LD      [IX+13],H
                LD      L,C
                LD      H,B
                RES     4,[HL]        ;APAGA EFECTO ENVOLVENTE ********** TEMPRAL
                XOR     A
                LD      [PSG_REG+13],A
                JR      LOCALIZA_NOTA

COM_EFECTO:     BIT     1,A             ;EFECTO DE SONIDO
                JR      Z,COM_ENVOLVENTE

                INC     HL
                LD      A,[HL]
                INC     HL
                LD      [IX+00],L
                LD      [IX+01],H

;INICIA EL SONIDO N [A]

INICIA_SONIDO:  LD      HL,TABLA_SONIDOS
                CALL    EXT_WORD
                LD      [PUNTERO_SONIDO],HL
                LD      HL,INTERR
                SET     2,[HL]
                RET

COM_ENVOLVENTE: BIT     2,A
                RET     Z               ;IGNORA - ERROR


                INC     HL
                LD      [IX+00],L
                LD      [IX+01],H
                LD      L,C
                LD      H,B
                LD	[HL],00010000B          ;ENCIEN EFECTO ENVOLVENTE ********** TEMPRAL
                JR      LOCALIZA_NOTA

LNJP0:          LD      A,[HL]
                INC     HL
                BIT     7,A
                JR      Z,NO_FIN_CANAL_A
                LD      L,[IX+6]        ;HL=[CANAL_A_B_C] REINICIA CANAL
                LD      H,[IX+7]
                LD      [IX+00H],L
                LD      [IX+01H],H
                JR      LOCALIZA_NOTA

NO_FIN_CANAL_A: LD      [IX+0],L        ;[PUNTERO_A_B_C]=HL GUARDA PUNTERO
                LD      [IX+1],H
                AND     A               ;NO REPRODUCE NOTA SI NOTA=0
                JR      Z,FIN_RUTINA
                BIT     6,A             ;SILENCIO?
                JR      Z,NO_SILENCIO_A
                LD	A,[BC]
                AND	00010000B
                JR	NZ,SILENCIO_ENVOLVENTE
                XOR     A
                LD	[BC],A		;RESET VOLUMEN
                LD	[IY+0],A
                LD	[IY+1],A
		RET
SILENCIO_ENVOLVENTE:
		LD	A,$FF
                LD	[PSG_REG+11],A
                LD	[PSG_REG+12],A
                LD	[PSG_REG+13],A
                
                LD	[IY+0],A
                LD	[IY+1],A
                RET

;NOTA : REPRODUCE UNA NOTA
;IN [A]=CODIGO DE LA NOTA
;   [IY]=REGISTROS DE FRECUENCIA

NOTA:           LD      L,C
                LD      H,B
                BIT     4,[HL]
                LD      B,A
                JR      NZ,EVOLVENTES
                LD      HL,DATOS_NOTAS
                RLCA                    ;X2
                LD      D,0
                LD      E,A
                ADD     HL,DE
                LD      A,[HL]
                LD      [IY+0],A
                INC     HL
                LD      A,[HL]
                LD      [IY+1],A
                RET

NO_SILENCIO_A:  CALL    NOTA            ;REPRODUCE NOTA

                LD      L,[IX+18]       ; HL=[PUNTERO_P_A0] RESETEA PAUTA
                LD      H,[IX+19]
                LD      [IX+12],L       ;[PUNTERO_P_A]=HL
                LD      [IX+13],H
FIN_RUTINA:     RET

;LOCALIZA EFECTO
;IN HL=[PUNTERO_P]

LOCALIZA_EFECTO:LD      L,[IX+0]       ;HL=[PUNTERO_P]
                LD      H,[IX+1]
                LD      A,[HL]
                CP      11000010B
                JR      NZ,LEJP0

                INC     HL
                LD      A,[HL]
                INC     HL
                LD      [IX+00],L
                LD      [IX+01],H
                JP	INICIA_SONIDO

LEJP0:          INC     HL
                BIT     7,A
                JR      Z,NO_FIN_CANAL_P
                LD      L,[IX+2]        ;HL=[CANAL_P] REINICIA CANAL
                LD      H,[IX+3]
                LD      [IX+00H],L
                LD      [IX+01H],H
                JR      LOCALIZA_EFECTO

NO_FIN_CANAL_P: LD      [IX+0],L        ;[PUNTERO_A_B_C]=HL GUARDA PUNTERO
                LD      [IX+1],H
                RET

;IN [A]=CODIGO DE LA ENVOLVENTE
;   [IY]=REGISTRO DE FRECUENCIA

EVOLVENTES:     LD      HL,DATOS_NOTAS
		;ADD	12
		RLCA                    ;X2
                LD      D,0
                LD      E,A
                ADD     HL,DE
                LD	E,[HL]
		INC	HL
		LD	D,[HL]
		;LD      [IY+0],E
                ;LD      [IY+1],D
		
		RR	D
		RR	E
		RR	D
		RR	E
		RR	D
		RR	E
		
		LD	A,E

                LD      [PSG_REG+11],A
                LD	A,D
                AND	00000111B
                LD      [PSG_REG+12],A
                LD      A,$0C
                LD      [PSG_REG+13],A
                XOR     A
                LD      [IY+0],A
                LD      [IY+1],A
                RET

;LEE REGISTRO PSG
;IN  [A]=REGISTRO
;OUT [A]=VALOR

;IN_SOUND:       OUT     [$A0],A
;                IN      A,[$A2]
;                RET

;EXTRAE UN WORD DE UNA TABLA
;IN:[HL]=DIRECCION TABLA
;   [A]= POSICION
;OUT[HL]=WORD

EXT_WORD:       LD      D,0
		ADD	A,A	;*2
                LD      E,A
                ADD     HL,DE
                LD      E,[HL]
                INC     HL
                LD      D,[HL]
                EX      DE,HL
                RET


; *************************************************************************************************************************


;________________________________________________________
; *************************************************************************************************************************


;BANCO DE INSTRUMENTOS 2 BYTES POR INT.

;[0][RET 2 OFFSET]
;[1][+-PITCH]

		INCLUDE "data/pautas.asm"

;DATOS DE LOS EFECTOS DE SONIDO

;EFECTOS DE SONIDO

;DW      SONIDO1,SONIDO2,SONIDO3;,SONIDO4,SONIDO5,SONIDO6,SONIDO7,SONIDO8

;DATOS MUSICA

TABLA_SONG:     DW      SONG_1,SONG_2,SONG_3,SONG_4,SONG_INTER;,SONG_END		;******** TABLA DE DIRECCIONES DE ARCHIVOS MUS comprimidos

DATOS_NOTAS:    DW $0000,$0000
		;DW $077C,$0708,
		DW $06B0,$0640,$05EC,$0594,$0544,$04F8,$04B0,$0470,$042C,$03FD
		DW $03BE,$0384,$0358,$0320,$02F6,$02CA,$02A2,$027C,$0258,$0238,$0216,$01F8
		DW $01DF,$01C2,$01AC,$0190,$017B,$0165,$0151,$013E,$012C,$011C,$010A,$00FC
		DW $00EF,$00E1,$00D6,$00C8,$00BD,$00B2,$00A8,$009F,$0096,$008E,$0085,$007E
		DW $0077,$0070,$006B,$0064,$005E,$0059,$0054,$004F,$004B,$0047,$0042,$003F
		DW $003B,$0038,$0035,$0032,$002F,$002C,$002A,$0027,$0025,$0023,$0021,$001F
		DW $001D,$001C,$001A,$0019,$0017,$0016,$0015,$0013,$0012,$0011,$0010,$000F

SONG_1:         INCBIN "bindata/syfuid.exp"	;Cancin ingame 1: syfuid
SONG_2:         INCBIN "bindata/shampoo.exp"	;Cancin ingame 2: shampoo
SONG_3:         INCBIN "bindata/maaorava.exp"	;Cancin ingame 3: maaorava
SONG_4:		INCBIN "bindata/maryjane.exp"	;Cancin ingame 4: maryjane
SONG_INTER:	INCBIN "bindata/weneed.exp"	;Cancin interludio y final
;SONG_END:	INCBIN "bindata/weneed.exp"	;Cancin final

INTERR:         DB     00               ;INTERRUPTORES 1=ON 0=OFF
                                        ;BIT 0=CARGA CANCION ON/OFF
                                        ;BIT 1=PLAYER ON/OFF
                                        ;BIT 2=SONIDOS ON/OFF
                                        ;BIT 3=EFECTOS ON/OFF

;MUSICA **** EL ORDEN DE LAS VARIABLES ES FIJO ******

SONG:           DB     00               ;DBN DE CANCION
TEMPO:          DB     00               ;DB TEMPO
TTEMPO:         DB     00               ;DB CONTADOR TEMPO
PUNTERO_A:      DW     00               ;DW PUNTERO DEL CANAL A
PUNTERO_B:      DW     00               ;DW PUNTERO DEL CANAL B
PUNTERO_C:      DW     00               ;DW PUNTERO DEL CANAL C

CANAL_A:        DW     BUFFER_DEC       ;DW DIRECION DE INICIO DE LA MUSICA A
CANAL_B:        DW     00               ;DW DIRECION DE INICIO DE LA MUSICA B
CANAL_C:        DW     00               ;DW DIRECION DE INICIO DE LA MUSICA C

PUNTERO_P_A:    DW     00               ;DW PUNTERO PAUTA CANAL A
PUNTERO_P_B:    DW     00               ;DW PUNTERO PAUTA CANAL B
PUNTERO_P_C:    DW     00               ;DW PUNTERO PAUTA CANAL C

PUNTERO_P_A0:   DW     00               ;DW INI PUNTERO PAUTA CANAL A
PUNTERO_P_B0:   DW     00               ;DW INI PUNTERO PAUTA CANAL B
PUNTERO_P_C0:   DW     00               ;DW INI PUNTERO PAUTA CANAL C

;CANAL DE EFECTOS - ENMASCARA OTRO CANAL

PUNTERO_P:      DW	00           	;DW PUNTERO DEL CANAL EFECTOS
CANAL_P:        DW     	00           	;DW DIRECION DE INICIO DE LOS EFECTOS

PSG_REG:        DB      00,00,00,00,00,00,00,10111000B,00,00,00,00,00,00,00    ;DB [11] BUFFER DE REGISTROS DEL PSG
PSG_REG_SEC:    DB      00,00,00,00,00,00,00,10111000B,00,00,00,00,00,00,00    ;DB [11] BUFFER SECUNDARIO DE REGISTROS DEL PSG
;EFECTOS DE SONIDO

N_SONIDO:       DB      0               ;DB : NUMERO DE SONIDO
PUNTERO_SONIDO: DW      0               ;DW : PUNTERO DEL SONIDO QUE SE REPRODUCE

;EFECTOS

PUNTERO_EFECTO: DW      0               ;DW : PUNTERO DEL SONIDO QUE SE REPRODUCE


;DATOS_NOTAS:    INCBIN "bindata/notas.dat"        ;DATOS DE LAS NOTAS
;DATOS_ENV:      INCBIN "bindata/env.dat"          ;DATOS DE LAS ENVOLVENTES

; VARIABLES__________________________




BUFFER_DEC:     DB      $00		;************************* mucha atencion!!!!
					; aqui se decodifica la cancion hay que dejar suficiente espacio libre.
					;*************************

